USE [BMS_HISTORY]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_PPBPUsageAuditLog]    Script Date: 6/14/2016 9:13:10 AM ******/
DROP PROCEDURE [dbo].[usp_Rpt_PPBPUsageAuditLog]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_PPBPUsageAuditLog]    Script Date: 6/14/2016 9:13:10 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


--PPBP Usage Audit Log Report
--Need Entered D/T, Requested D/T, Removed D/T, Edit Event D/t, User, Transaction ("Patient" + record history)
--select * from TRANSFER_REQ_H WHERE ACT_ID =378
--EXEC usp_Rpt_PPBPUsageAuditLog '4/23/2001', '4/29/2016', 0, 'DNS           \vhaisdhornd', '69378E0F-B210-493B-B2A1-2130C9F7F394', 'PPBPUsageAuditLog'
--EXEC usp_Rpt_PPBPUsageAuditLog '4/23/2001', '4/29/2016', 0, 'DNS', '69378E0F-B210-493B-B2A1-2130C9F7F394', 'PPBPUsageAuditLog'
--exec usp_Rpt_PPBPUsageAuditLog @DATE_FROM='2016-05-10 00:00:01',@DATE_TO='2016-05-17 23:59:59',@TIME_ZONE_MINUTES_OFFSET=-360,@UserID=N'DNS   HORND@DNS           ',@FACILITIES_IDS=N'27127BEC-7FFC-4AE3-AB51-5FC12E94978E,DE5F7D7A-2B23-4238-A62C-95F98C799FBF,B9BD1F1E-F01D-4436-A119-C3F3411F1768,AD3296DE-4489-4C86-9073-116BCBFC5807,BF033FD3-C3FF-4597-9309-8506AF025CCF,0345964C-1C40-4C67-9926-0FF3646F76E3,384246E5-2383-4164-A5F8-BBC4DB65268C,074A4A23-BD1C-4645-BA17-FD4285CB8DD1,82664146-A432-4D5D-ACE9-3473A94A4843,199D6E6C-B791-4570-BD0C-A4F21C11B1C9,B76FD5CC-45A6-4396-BAE5-390BBFD9608A,E890E0DD-2A5B-4DF2-9BD3-A80FF7880D68,6B2EEF5C-B569-429B-817D-11D67F4FB7A4,37BB9F69-E6A0-4686-96CF-E0D6A65A4229,123F5F3D-0220-448B-A3EA-30CC27440D3E,D7D99DDA-6395-4230-9769-7D34281218BD,BD0BE09A-DA6B-4BC9-8512-55DB164A3936,83993150-11EB-46B6-A140-66249407EA99,4228A303-D83B-4D29-9C63-9CF38723A609,B8E19493-FF5D-4D0F-9475-531AB2876D55,A4D69C85-2EFE-4E58-8F51-87A3367D5360,603990B0-6C86-4DCC-A0A2-EDB7EDCF86EE,C9120516-1CA1-488D-A9B7-9F7E8C5CB163,451FDA5B-BF99-4356-A6AD-BD5D1619CD8D,3DC03304-2593-4CE7-BB7C-DAD5036CC466,142B212F-FBBB-4E03-ADB3-6BFDE81EAF3C,5D59E39A-D5DF-4FDB-AD16-DFBF49A2333F,2CF9A166-C3D4-49EC-8C62-F0E369186F37,2908DE1A-AE4A-469C-9C9F-F10857B23639,86831D20-AEBE-4280-B67D-BE0B653280D5,69378E0F-B210-493B-B2A1-2130C9F7F394,85A09908-5BFA-47F1-BEB5-FEBB2E7BE543,AB19779C-94E5-4A50-9139-581A21A84109,158D29E4-76F3-4346-B0E0-D9763CE19C83,AB3A91F8-7180-49B5-B67D-EE7EEBDAEC84,112392FE-7168-4997-A045-246A3622F254,66591DB9-16B7-436A-8BA3-C58D167A588D,059BE374-E52D-4959-AAB4-4BA098FF61E8,3CE8A5F0-82BF-41A2-B159-200B90641A43,160CA25C-AF38-45A6-8F97-B6680627F971,8BF6E455-0BAA-4C62-B649-D5FC37AA88FB,50FF2AC9-0BDC-4C47-8605-68A0558E2B6E,89880507-FF65-4570-A1C4-A6825A3429B5,93AFBDDE-9B8A-4625-932B-2F8FA88646E4,804892C0-C264-46E7-BD1C-9609B4CA4F1C,5151717F-9911-46CE-936D-EAEB881ED4B0,E4EF5C91-C8C7-4979-A652-9B74F43A3C29,ACA61E46-009A-4878-B5E6-70CDEAB1E040,45475D91-28BF-4018-9949-C418A0671DDD,BEAE8ECD-F483-4538-BE2D-673CAB60DFE5,CC262497-9ED7-4A61-AFFA-9F26197603AB,888EEAE2-2369-49DE-98CF-A9A8E9EE17F5,286566E2-E679-4FB5-88A9-BA37B3561B3D,E95499CA-500C-482D-9ECB-BA4B7599EB82,A84FE131-C31C-4044-AFDB-3B61A531919A,DD64B757-F066-4F2D-AF89-EC50A8AF1CD7,44330A17-1C70-463F-A099-56668281B80A,33617A96-3E0F-487C-8A4C-3E141AA6B5F1,4F62B779-57D7-4ECC-91C5-24A1F40B089A,CE0BE571-1C7A-4B54-8013-10544D9777E1,324DB4DF-8BA2-46B7-9C6D-48004D412BCE,2F4332A8-9489-4AC6-BBB9-7719508A30E1,FCED40B3-BF53-4FB0-A7CB-F43BD99E2D30,FBB30408-0C7B-4B6E-AAC5-67F98970DF6F,4F0216B5-1AD6-42DD-AEE0-C76DA395B8E3,5873DC3C-7727-4B33-A2DB-BAE85FFBB93B,719FF4AF-FC82-4031-9386-CA8FBCB291AF,3A31E917-6985-4C49-BB3A-7F1EACC32431,C4721CB8-126C-474D-A75D-E1ECA55A9E26,82F22B45-1DC4-44A1-B574-76AED9EE08ED,FC6080D7-C9CA-455F-8A9A-0CDEF9084821,5055F460-A241-494D-97B7-AAF1CE94C088,F29D2134-C562-4527-9539-8D3A6D6460CB,5A2AB598-B1E8-490E-9FDD-8EA4E2A51BAB,924662F7-9425-48B0-A1D1-84FD83805B2B,4EA4AC4F-D512-4ADF-8014-4D21FE1A8289,A98558D4-505C-4046-A24D-BCC24A46D5B0,69450451-12E8-4084-B6FA-013309A5F814,15E538E4-EFCB-474A-95F2-599E6CFE1AF8,0A8AD105-4069-4EEB-815B-C13C8DFB2E09,DF945CD2-25F7-48E5-BE40-C7AB0823D0ED,D51D0E56-2883-4F66-BE47-4D99ED6DE082,3F246B9F-E91F-4BC7-8131-56F6174C776A,C2785D26-C5A0-41C0-9906-3C0DAA86D07A,280DFF7D-D689-43FA-AD25-0BCFB9802954,87D643D5-A086-4E03-892C-173C76C0CF58,8EAFB939-1824-4A75-B808-A9B54C393399,F21774A4-A832-4AB9-B5AB-AA38615F1730,7982F659-534B-4DC9-AEE9-36AA7E0BF035,17F6135E-2ECA-416C-B066-F236EDD752AF,8F30BEDF-C177-4ECB-9328-4F1294327A6B,8FE3BD98-079F-4B27-8129-CDFAA27A5992,E8934FDE-8AC4-436E-B9FD-D74075C2CBFC,726332B6-3EEB-469D-BEBF-68A375685473,7F661DD6-8801-4FA8-92F0-B514818AEEB8,0023CC35-177F-4052-8B0B-8ECA94670B3B,FA854ED7-7249-4398-BD29-62A26483D53B,BC9DF7D5-3929-4AC0-BD5F-CD091FF337F4,6B160084-A6E6-4F2B-9016-168B5BCD780C,304DB2BE-36AC-4CB8-8B61-3A6DBDD0E675,5E4D685F-33E8-4FFE-A46E-C420EE4DC889,D498F5AC-788A-4CFD-87CB-F6832AD5C085,0E99FA6A-FA78-4F88-B88C-24293994876F,6ED340B4-DE87-4DC3-B888-3112486D6348,682D2688-4175-4140-BDBB-55188C4B49D2,07F2F24E-E08F-495C-8DE4-EF75EA32EF25,09B3BEEA-D078-41E5-ACBA-661838CD0E25,1924A041-4769-4219-AE42-11C7B8FAB6FE,A09C8658-C40F-4825-BA67-375F11B50BD9,2A82DF79-0691-4811-9B9C-03231DDF4E6A,487D5CD0-808A-4FF0-A353-B566F15CB107,EEE2965C-5849-4B9E-912A-1D6046A48C61,2C6DA1BE-D0A1-42BD-AAAA-8794CAC69E00,FCD16EFC-D965-4853-9B13-C33042268561,C33E6708-FBB1-47DE-8394-505A8FE1688C,72244CFC-3520-4547-8F69-C496AECC3784,6BB1F574-1082-43C3-9A5B-475B83334F3B,0E3BF04C-9A89-4F47-AFC7-5A62F8845F47,220977D6-F59B-447F-95E4-B4AE1E306702,145C69BD-B35C-481A-8F30-7C64FD089FCE,188D2285-3956-409D-9E32-27F9C20184EE,806203F9-B7D0-4247-A046-079A00A73F07,B64FD9FB-E6AF-4105-8007-67918B163230,E67EA882-EA3E-4B84-94A2-8BE35EE8869C,0E13380A-F2F1-4612-A29F-78EF36F511AB,4AD9DFDC-3BCE-4C6E-A84F-46905DC0009A,8D84989D-68C0-48DA-8E02-5CF2EE48B57F,A3B79F41-493E-43B4-8A3D-3A7254CE2017,CCA247D3-98BA-49BB-BA3B-43AAF4A3EC56,E2DCB406-9E91-4AF3-891E-F4A6427F3D62,3E1925AC-97DC-4755-B733-60170BFD8A1F,913090D9-CE98-4D34-9351-7D7E0E7F6B37,5354BB42-B12F-4AC6-8FEC-C6071B0DB9DE,5F1AB3DC-E4C6-4EAF-ACD3-475DCBC1CD6D,F2E591EB-019E-4676-ACE0-F29AB5608E37,71399753-46C7-4B53-90DF-AEFC3BBF3E72,CED3D7F7-0C1E-429A-AC1B-853025B2EE51,980EE0B5-AF61-4FE1-9320-8C745D655569,D94F05E0-0243-42D2-A43C-83E3C81FB856,BD202829-2A88-4DC2-A207-CBBAB892C3C2,5DB10171-F7A4-4D3E-A1C2-B73A3E93783C,77E6C1A6-3194-4F2A-B847-01B1C57DA8BD,84B14793-D236-4E26-8D62-ECEF51A8B914',@REPORT_TYPE=N'PPBPUsageAuditLog'

CREATE PROCEDURE [dbo].[usp_Rpt_PPBPUsageAuditLog]
	@DATE_FROM DATETIME,
	@DATE_TO DATETIME,
	@TIME_ZONE_MINUTES_OFFSET INT,
	@UserID NVARCHAR(500),
	@FACILITIES_IDS NVARCHAR(MAX) = '',
	@REPORT_TYPE NVARCHAR(50)
AS
BEGIN
SET NOCOUNT ON;

IF (@REPORT_TYPE = 'PPBPUsageAuditLog')
BEGIN

	CREATE TABLE #TBL_FACILITY (
		SOURCE_ID NVARCHAR(250) PRIMARY KEY, 
		FACILITY_NAME NVARCHAR(250), 
		TIMEZONE_OFFSET INT)
	
	INSERT INTO #TBL_FACILITY(SOURCE_ID, FACILITY_NAME, TIMEZONE_OFFSET) 
	SELECT DISTINCT CONVERT(NVARCHAR(250), FACILITY.VALUE), ORG.NAME,  [dbo].[ufn_GetOffsetByFacilityUID](VALUE) 
	FROM dbo.ufn_Split(@FACILITIES_IDS, ',') AS FACILITY
	INNER JOIN BMS_EIS.dbo.ENTITY AS ENTITY 
	  ON ENTITY.IDENTIFIER = FACILITY.VALUE 
	INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS ORG 
	  ON ORG.PFK_ORGANIZATION = ENTITY.PK_ENTITY

	CREATE TABLE #TRANHISTORY (
			PK int,
			ACT_ID int,
			TRANSACTION_TYPE_CODE varchar(50), 
			ERA_ID int,
			DIAGNOSIS nvarchar(250),
			CURRENT_LOCATION nvarchar(150),
			COMMENTS nvarchar(250),
			SPECIALTY_ID int,
			LOCATION_ADMISSION_DATE datetime,
			CONTRACT_ID int,
			IS_NATIONAL_WAIT_LIST bit,
			FACILITY_UID uniqueidentifier,
			ENTERED_DATE datetime,
			REQUESTED_DATE datetime,
			REMOVED_DATE datetime,
			EDITED datetime,
			LAST_EDIT_BY nvarchar(100),
			PATIENT_NAME nvarchar(50),
			ACTION_HISTORY varchar(max)
	)
	INSERT #TRANHISTORY
	SELECT	TRANHISTORY.PK,
			TRANHISTORY.ACT_ID,
			TRANHISTORY.TRANSACTION_TYPE_CODE,
			TRANHISTORY.ERA_ID,
			TRANHISTORY.DIAGNOSIS,
			TRANHISTORY.CURRENT_LOCATION,
			TRANHISTORY.COMMENTS,
			TRANHISTORY.SPECIALITY_ID,
			TRANHISTORY.LOCATION_ADMISSION_DATE,
			TRANHISTORY.CONTRACT_ID,
			TRANHISTORY.IS_NATIONAL_WAIT_LIST,
			TRANHISTORY.FACILITY_UID,
			--TRANHISTORY.DATE as ENTERED_DATE,
			ACTHISTORY.CREATION_DATE as ENTERED_DATE, 
			TRANHISTORY.REQUESTED_DATE as REQUESTED_DATE, 
			TRANEVNH.DISPOSITION_DATE AS REMOVED_DATE,
			TRANHISTORY.EDITED as EDIT_EVENT, 
			--ACTHISTORY.DATE as EDIT_EVENT,
			TRANHISTORY.LAST_EDIT_BY as LAST_EDIT_BY, 

			SUBSTRING(PERSON.[NAME_FIRST_GIVEN], 1, 1) + PERSON.[NAME_FAMILY] + ' ' + SUBSTRING(s.[IDENTIFIER_EXTENSION], 8, 4) AS PATIENTNAME,
			CASE WHEN TRANHISTORY.TRANSACTION_TYPE_CODE = 'I' THEN 'NEW RECORD' 
				 WHEN TRANHISTORY.TRANSACTION_TYPE_CODE = 'U' THEN 'UPDATED'
				 WHEN TRANHISTORY.TRANSACTION_TYPE_CODE = 'D' THEN 'DELETED'
			END as ACTIONTYPE 
	FROM TRANSFER_REQ_H TRANHISTORY
	INNER JOIN #TBL_FACILITY FAC
		ON TRANHISTORY.FACILITY_UID = FAC.SOURCE_ID
	INNER JOIN ACT_H ACTHISTORY
		ON TRANHISTORY.ACT_ID = ACTHISTORY.ID
	INNER JOIN BMS_EIS.dbo.ENTITY AS ENTITY 
		ON ENTITY.IDENTIFIER = ACTHISTORY.PATIENT_UID
	INNER JOIN BMS_EIS.dbo.EHL7_PERSON AS PERSON 
		ON PERSON.PFK_PERSON = ENTITY.PK_ENTITY
	INNER JOIN BMS_EIS.dbo.EHL7_UID AS S 
		ON S.FK_ENTITY = PERSON.PFK_PERSON AND S.IDENTIFIER_ROOT = 'SSN'
	LEFT JOIN ACT_H ACTLAST
		ON TRANHISTORY.ACT_ID = ACTLAST.PARENT_ACT_ID
	LEFT JOIN TRANSFER_EVN_H TRANEVNH
		ON ACTLAST.ID = TRANEVNH.ACT_ID

	WHERE TRANHISTORY.EDITED BETWEEN @DATE_FROM AND @DATE_TO
	OPTION (MAXDOP 1) 
	--SELECT * FROM #TRANHISTORY

	SELECT DISTINCT 
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.ENTERED_DATE), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.ENTERED_DATE), 108) as ENTERED_DATE, 
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.REQUESTED_DATE), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.REQUESTED_DATE), 108) as REQUESTED_DATE,
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.REMOVED_DATE), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.REMOVED_DATE), 108) as REMOVED_DATE,
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.EDITED), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_WAITING_LIST.EDITED), 108) as EDITED,
		   H_WAITING_LIST.LAST_EDIT_BY,
			H_WAITING_LIST.PATIENT_NAME,
		   H_WAITING_LIST.ACT_ID,
		   H_WAITING_LIST.ACTION_HISTORY,
		   --H_WAITING_LIST.ACTION_HISTORY,
	CASE WHEN H_WAITING_LIST.TRANSACTION_TYPE_CODE = 'U' THEN 
		CASE WHEN H_WAITING_LIST.ERA_ID <> PREVIOUS_H_WAITING_LIST.ERA_ID OR (H_WAITING_LIST.ERA_ID IS NULL AND PREVIOUS_H_WAITING_LIST.ERA_ID IS NOT NULL) OR (H_WAITING_LIST.ERA_ID IS NOT NULL AND PREVIOUS_H_WAITING_LIST.ERA_ID IS NULL)
			THEN  'ERA FROM ' + ISNULL(ERA1.DISPLAY_NAME,'<EMPTY>') + ' TO ' + ISNULL(ERA2.DISPLAY_NAME,'') + char(13)+char(10) ELSE '' END + ' '+
		CASE WHEN H_WAITING_LIST.DIAGNOSIS <> PREVIOUS_H_WAITING_LIST.DIAGNOSIS OR (H_WAITING_LIST.DIAGNOSIS IS NULL AND PREVIOUS_H_WAITING_LIST.DIAGNOSIS IS NOT NULL) OR (H_WAITING_LIST.DIAGNOSIS IS NOT NULL AND PREVIOUS_H_WAITING_LIST.DIAGNOSIS IS NULL)
			THEN  'DIAGNOSIS FROM ' + ISNULL(PREVIOUS_H_WAITING_LIST.DIAGNOSIS,'<EMPTY>') + ' TO ' + ISNULL(H_WAITING_LIST.DIAGNOSIS,'')  + char(13)+char(10) ELSE '' END + ' ' +
		CASE WHEN H_WAITING_LIST.CURRENT_LOCATION <> PREVIOUS_H_WAITING_LIST.CURRENT_LOCATION OR (H_WAITING_LIST.CURRENT_LOCATION IS NULL AND PREVIOUS_H_WAITING_LIST.CURRENT_LOCATION IS NOT NULL) OR (H_WAITING_LIST.CURRENT_LOCATION IS NOT NULL AND PREVIOUS_H_WAITING_LIST.CURRENT_LOCATION IS NULL)
			THEN  'CURRENT LOCATION FROM ' + ISNULL(PREVIOUS_H_WAITING_LIST.CURRENT_LOCATION, '<EMPTY>') + ' TO ' + ISNULL(H_WAITING_LIST.CURRENT_LOCATION,'') + char(13)+char(10) ELSE '' END + ' ' +
		CASE WHEN H_WAITING_LIST.SPECIALTY_ID <> PREVIOUS_H_WAITING_LIST.SPECIALTY_ID OR (H_WAITING_LIST.SPECIALTY_ID IS NULL AND PREVIOUS_H_WAITING_LIST.SPECIALTY_ID IS NOT NULL) OR (H_WAITING_LIST.SPECIALTY_ID IS NOT NULL AND PREVIOUS_H_WAITING_LIST.SPECIALTY_ID IS NULL)
			THEN  'SPECIALITY FROM ' + ISNULL(SPECIALTY1.DISPLAY_NAME,'<EMPTY>') + ' TO ' + ISNULL(SPECIALTY2.DISPLAY_NAME,'') + char(13)+char(10) ELSE '' END + ' ' +
		CASE WHEN H_WAITING_LIST.IS_NATIONAL_WAIT_LIST <> PREVIOUS_H_WAITING_LIST.IS_NATIONAL_WAIT_LIST THEN 'NATIONAL WAIT LIST FROM ' + 
			CASE WHEN PREVIOUS_H_WAITING_LIST.IS_NATIONAL_WAIT_LIST = 1 THEN 'Yes' ELSE 'No' END + ' TO ' + 
			CASE WHEN H_WAITING_LIST.IS_NATIONAL_WAIT_LIST = 1 THEN 'Yes' ELSE 'No' END + char(13)+char(10) ELSE '' END + ' ' +
		CASE WHEN H_WAITING_LIST.REQUESTED_DATE <> PREVIOUS_H_WAITING_LIST.REQUESTED_DATE OR (H_WAITING_LIST.REQUESTED_DATE IS NULL AND PREVIOUS_H_WAITING_LIST.REQUESTED_DATE IS NOT NULL) OR (H_WAITING_LIST.REQUESTED_DATE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.REQUESTED_DATE IS NULL) 
			THEN 'REQUESTED ADMISSION DATE FROM ' + CASE WHEN PREVIOUS_H_WAITING_LIST.REQUESTED_DATE IS NULL THEN '<Empty>' ELSE ISNULL(convert(varchar(20),PREVIOUS_H_WAITING_LIST.REQUESTED_DATE,101), '') + ' ' + ISNULL(convert(varchar(20),PREVIOUS_H_WAITING_LIST.REQUESTED_DATE,108), '') + ' ' + ISNULL(right(convert(varchar(30),PREVIOUS_H_WAITING_LIST.REQUESTED_DATE,109),2),'') END +
				' TO ' + CASE WHEN H_WAITING_LIST.REQUESTED_DATE IS NULL THEN '<Empty>' ELSE ISNULL(convert(varchar(20),H_WAITING_LIST.REQUESTED_DATE,101), '') + ' ' + ISNULL(convert(varchar(20),H_WAITING_LIST.REQUESTED_DATE,108),'') + ' ' + ISNULL(right(convert(varchar(30),H_WAITING_LIST.REQUESTED_DATE,109),2),'') + char(13)+char(10) END ELSE '' END + ' ' +
		CASE WHEN H_WAITING_LIST.LOCATION_ADMISSION_DATE <> PREVIOUS_H_WAITING_LIST.LOCATION_ADMISSION_DATE OR (H_WAITING_LIST.LOCATION_ADMISSION_DATE IS NULL AND PREVIOUS_H_WAITING_LIST.LOCATION_ADMISSION_DATE IS NOT NULL) OR (H_WAITING_LIST.LOCATION_ADMISSION_DATE IS NOT NULL AND PREVIOUS_H_WAITING_LIST.LOCATION_ADMISSION_DATE IS NULL)
			THEN 'COMM HOSP ADMISSION DATE FROM ' + CASE WHEN PREVIOUS_H_WAITING_LIST.LOCATION_ADMISSION_DATE IS NULL THEN '<Empty>' ELSE ISNULL(convert(varchar(20),PREVIOUS_H_WAITING_LIST.LOCATION_ADMISSION_DATE,101),'') + ' '+ ISNULL(convert(varchar(20),PREVIOUS_H_WAITING_LIST.LOCATION_ADMISSION_DATE,108),'') + ' ' + ISNULL(right(convert(varchar(30),PREVIOUS_H_WAITING_LIST.LOCATION_ADMISSION_DATE,109),2),'') END +
				' TO ' + CASE WHEN H_WAITING_LIST.LOCATION_ADMISSION_DATE IS NULL THEN '<Empty>' ELSE ISNULL(convert(varchar(20),H_WAITING_LIST.LOCATION_ADMISSION_DATE,101),'') + ' ' + ISNULL(convert(varchar(20),H_WAITING_LIST.LOCATION_ADMISSION_DATE,108),'') + ' ' + ISNULL(right(convert(varchar(30),H_WAITING_LIST.LOCATION_ADMISSION_DATE,109),2),'') + char(13)+char(10) END ELSE '' END + ' ' +
		CASE WHEN H_WAITING_LIST.CONTRACT_ID <> PREVIOUS_H_WAITING_LIST.CONTRACT_ID OR (H_WAITING_LIST.CONTRACT_ID IS NULL AND PREVIOUS_H_WAITING_LIST.CONTRACT_ID IS NOT NULL) OR (H_WAITING_LIST.CONTRACT_ID IS NOT NULL AND PREVIOUS_H_WAITING_LIST.CONTRACT_ID IS NULL)
			THEN 'CONTRACT FROM ' + ISNULL(CONTRACT1.DISPLAY_NAME,'<EMPTY>') + ' TO ' + ISNULL(CONTRACT2.DISPLAY_NAME,'') + char(13)+char(10) ELSE '' END + ' ' +
		CASE WHEN H_WAITING_LIST.FACILITY_UID <> PREVIOUS_H_WAITING_LIST.FACILITY_UID OR (H_WAITING_LIST.FACILITY_UID IS NULL AND PREVIOUS_H_WAITING_LIST.FACILITY_UID IS NOT NULL) OR (H_WAITING_LIST.FACILITY_UID IS NOT NULL AND PREVIOUS_H_WAITING_LIST.FACILITY_UID IS NULL)
			THEN 'VA ADMISSION FACILITY FROM ' + ISNULL(ORG1.NAME,'<EMPTY>') + ' TO ' + ISNULL(ORG2.NAME,'') + char(13)+char(10) ELSE '' END  
	ELSE ''--H_WAITING_LIST.ACTION_HISTORY 
	END as TRAN_UPDS,
	CASE WHEN H_WAITING_LIST.COMMENTS <> PREVIOUS_H_WAITING_LIST.COMMENTS OR (H_WAITING_LIST.COMMENTS IS NULL AND PREVIOUS_H_WAITING_LIST.COMMENTS IS NOT NULL) OR (H_WAITING_LIST.COMMENTS IS NOT NULL AND PREVIOUS_H_WAITING_LIST.COMMENTS IS NULL)
		THEN  'COMMENTS FROM ' + ISNULL(PREVIOUS_H_WAITING_LIST.COMMENTS,'<EMPTY>') + ' TO ' + ISNULL(H_WAITING_LIST.COMMENTS,'') + char(13)+char(10) ELSE '' END as TRAN_COMMENTS
	FROM #TRANHISTORY H_WAITING_LIST
	LEFT JOIN #TRANHISTORY AS PREVIOUS_H_WAITING_LIST ON
	PREVIOUS_H_WAITING_LIST.ACT_ID = H_WAITING_LIST.ACT_ID AND
	PREVIOUS_H_WAITING_LIST.PK < H_WAITING_LIST.PK
	LEFT JOIN CONCEPT_H as ERA1 
	ON PREVIOUS_H_WAITING_LIST.ERA_ID = ERA1.ID
	AND ERA1.CODE_SYSTEM_NAME = 'ERA'
	LEFT JOIN CONCEPT_H as ERA2 
	ON H_WAITING_LIST.ERA_ID = ERA2.ID
	AND ERA2.CODE_SYSTEM_NAME = 'ERA'
	LEFT JOIN CONCEPT_H as SPECIALTY1
	ON PREVIOUS_H_WAITING_LIST.SPECIALTY_ID = SPECIALTY1.ID
	AND SPECIALTY1.CODE_SYSTEM_NAME = 'VistaSpecialty'	
	LEFT JOIN CONCEPT_H as SPECIALTY2
	ON H_WAITING_LIST.SPECIALTY_ID = SPECIALTY2.ID
	AND SPECIALTY1.CODE_SYSTEM_NAME = 'VistaSpecialty'
	LEFT JOIN CONCEPT_H as CONTRACT1
	ON PREVIOUS_H_WAITING_LIST.CONTRACT_ID = CONTRACT1.ID
	AND CONTRACT1.CODE_SYSTEM_NAME = 'StrictDecision'
	LEFT JOIN CONCEPT_H as CONTRACT2
	ON H_WAITING_LIST.CONTRACT_ID = CONTRACT2.ID
	AND CONTRACT2.CODE_SYSTEM_NAME = ' StrictDecision'
	LEFT JOIN BMS_EIS.dbo.ENTITY AS ENTITY1 ON ENTITY1.IDENTIFIER = PREVIOUS_H_WAITING_LIST.FACILITY_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS ORG1 ON ORG1.PFK_ORGANIZATION = ENTITY1.PK_ENTITY
	LEFT JOIN BMS_EIS.dbo.ENTITY AS ENTITY2 ON ENTITY2.IDENTIFIER = H_WAITING_LIST.FACILITY_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS ORG2 ON ORG2.PFK_ORGANIZATION = ENTITY2.PK_ENTITY
	OPTION (MAXDOP 1) 
	DROP TABLE #TRANHISTORY

END
END

GO


